package com.vf106.tools.utils.volley;

import android.util.Log;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * Created by maorui on 2018/1/18.
 */

public class PostFormRequest extends Request<JSONObject> {

    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";

    /**
     * The correct data is dropped when the
     */
    private ResponseListener mListener;
//    private Gson mGson;
//    private Type mClazz;
    private List<FormText> mListItem;

    private String BOUNDARY = "---------8888888888888";
    private String MULTIPART_FORM_DATA = "multipart/form-data";

    public PostFormRequest(String url, List<FormText> listItem, ResponseListener listener) {
        super(Method.POST, url, listener);
        this.mListener = listener;
        setShouldCache(false);
        mListItem = listItem;
    }

    /**
     * Here's where we start parsing the data
     *
     * @param response Response from the network
     * @return
     */
    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset(response.headers, DEFAULT_PARAMS_ENCODING));
            JSONObject result = null;
            if (jsonString != null && jsonString.length() > 0)
                result = new JSONObject(jsonString);

            return Response.success(result, HttpHeaderParser.parseCacheHeaders(response));
        } catch (UnsupportedEncodingException e) {
            return Response.error(new ParseError(e));
        } catch (JSONException je) {
            return Response.error(new ParseError(je));
        }
    }

    /**
     * Callback the correct data
     *
     * @param response The parsed response returned by
     */
    @Override
    protected void deliverResponse(JSONObject response) {
        mListener.onResponse(response);
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        if (mListItem == null || mListItem.size() == 0) {
            return super.getBody();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int N = mListItem.size();
        FormText formText;
        for (int i = 0; i < N; i++) {
            formText = mListItem.get(i);
            StringBuffer sb = new StringBuffer();
            /*first line:"--" + boundary + "\r\n" ;*/
            sb.append("--" + BOUNDARY);
            sb.append("\r\n");
            /*second line:"Content-Disposition: form-data; name="Name of the parameter"" + "\r\n" ;*/
            sb.append("Content-Disposition: form-data;");
            sb.append("name=\"");
            sb.append(formText.getName());
            sb.append("\"");
            sb.append("\r\n");
            /*third line:"\r\n" ;*/
            sb.append("\r\n");
            /*Fourth line: "Value of the parameter" + "\r\n" ;*/
            sb.append(formText.getValue());
            sb.append("\r\n");
            try {
                bos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        /*closing line (of text):"--" + boundary + "--" + "\r\n" ;*/
        String endLine = "--" + BOUNDARY + "--" + "\r\n";
        try {
            bos.write(endLine.toString().getBytes(StandardCharsets.UTF_8));
        } catch (IOException e) {
            e.printStackTrace();
        }
        Log.d("PostFormRequest", "=====formText====\n" + bos.toString());
        return bos.toByteArray();
    }

    /*Get the content type, in this case the form type*/
    @Override
    public String getBodyContentType() {
        return MULTIPART_FORM_DATA + "; boundary=" + BOUNDARY;
    }


    public interface ResponseListener extends Response.ErrorListener, Response.Listener<JSONObject> {
        void onResponse(JSONObject response);
    }
}
